﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IndianHealthService.BMXNet.Ado
{

    /// <summary>
    /// The event args for all DataTableFuture events.  
    /// </summary>
    /// <remarks>
    /// The DataTableFuture events are trigger in the non-UI thread and will break any application that is not managing it's
    /// UI calls properly.  If implementing a basic GUI-based application, it's recommended to set the InvokedControl on
    /// every DataTableFuture you created.
    /// This EventArgs provides the future, which is the same instance created when the Async call was made.
    /// </remarks>
    public class DataTableFutureEventArgs:EventArgs
    {
        private DataTableFuture _future = null;
        /// <summary>
        /// The future object that can be used to determine the state of the future, cancel the future, and perform
        /// some post future processing.
        /// </summary>
        public DataTableFuture Future
        {
            get { return _future; }
            set { _future = value; }
        }
    }
}
